<?php
/*--------------------------------------------------------------
   CompatibilityMapper.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\DashboardWidget\Services\Mapper;

use Gambio\Admin\Modules\Statistics\App\DashboardWidget\Model\Collections\Values;
use Gambio\Admin\Modules\Statistics\App\DashboardWidget\Model\Entities\DataProviderResult;
use Gambio\Admin\Modules\Statistics\App\DashboardWidget\Model\Exceptions\CouldNotMapDataProviderResultException;
use Gambio\Admin\Modules\Statistics\App\DashboardWidget\Services\Factories\ConversionDataProviderResultFactory;
use Gambio\Admin\Modules\Statistics\App\DashboardWidget\Services\Factories\OrdersDataProviderResultFactory;
use Gambio\Admin\Modules\Statistics\App\DashboardWidget\Services\Factories\SalesDataProviderResultFactory;
use Gambio\Admin\Modules\Statistics\App\DashboardWidget\Services\Factories\VisitorsDataProviderResultFactory;

class CompatibilityMapper
{
    /**
     * @var OrdersDataProviderResultFactory
     */
    private $ordersDataProviderResultFactory;
    
    /**
     * @var ConversionDataProviderResultFactory
     */
    private $conversionDataProviderResultFactory;
    
    /**
     * @var SalesDataProviderResultFactory
     */
    private $salesDataProviderResultFactory;
    
    /**
     * @var VisitorsDataProviderResultFactory
     */
    private $visitorsDataProviderResultFactory;
    
    
    /**
     * Constructor.
     */
    public function __construct(
        OrdersDataProviderResultFactory $ordersDataProviderResultFactory,
        ConversionDataProviderResultFactory $conversionDataProviderResultFactory,
        SalesDataProviderResultFactory $salesDataProviderResultFactory,
        VisitorsDataProviderResultFactory $visitorsDateProviderResultFactory
    ) {
        $this->ordersDataProviderResultFactory     = $ordersDataProviderResultFactory;
        $this->conversionDataProviderResultFactory = $conversionDataProviderResultFactory;
        $this->salesDataProviderResultFactory      = $salesDataProviderResultFactory;
        $this->visitorsDataProviderResultFactory   = $visitorsDateProviderResultFactory;
    }
    
    
    /**
     * Map to data result factory.
     */
    public function mapToDataResultFactory(string $key, Values $values): DataProviderResult
    {
        switch ($key) {
            case 'orders':
                return $this->ordersDataProviderResultFactory->create($values);
            case 'sales':
                return $this->salesDataProviderResultFactory->create($values);
            case 'visitors':
                return $this->visitorsDataProviderResultFactory->create($values);
            case 'conversion':
                return $this->conversionDataProviderResultFactory->create($values);
            default:
                throw CouldNotMapDataProviderResultException::invalidKeyProvided($key);
        }
    }
}